#ifndef TOOLLENSDISTORTION_H__
#define TOOLLENSDISTORTION_H__

enum
{
	//---------------------------------------------
	// Copied from drendersettings.h, and CM_ prefix added
	// Allows state to be directly copied across in either direction,
	// although for these parameters this isn't actually required.
	CM_RDATA_FILMASPECT								= 6006,
	CM_RDATA_FILMPRESET								= 6007,
	CM_RDATA_FILMPRESET_CUSTOM								= 0,
	CM_RDATA_FILMPRESET_SQUARE								= 1, // 1:1
	CM_RDATA_FILMPRESET_STANDARD							= 2, // 4:3
	CM_RDATA_FILMPRESET_HDTV             		= 3, // 16:9
	CM_RDATA_FILMPRESET_35MMSTILL        		= 4, // 3:2
	CM_RDATA_FILMPRESET_WIDESCREEN       		= 5, // 14:9
	CM_RDATA_FILMPRESET_35MM             		= 6, // 1.85:1
	CM_RDATA_FILMPRESET_PANAVISION       		= 7, // 2.39:1

	 // WARN: Don't add any more elements below without restarting sequence number.
	ADD_NEW_LINE = 10000,
	DELETE_LINE,
	ADD_NEW_TRIPLINE,
	DELETE_TRIPLINE,
	DELETE_SELECTED_LINE_MANUAL,
	DELETE_SELECTED_LINE_AUTOMATIC,

	CM_IMAGE_FILENAME = 10500,
	CM_IMAGE_RESET,
	CM_IMAGE_RELOAD,

	IDC_STATUS_STR,  // Used in res
	IDC_SELECTED_STR,   // Used in res
	IDC_SELECTED_STATE,

	PH_LINEINTERNALS = 11000,

	PH_TRIPLINEINTERNALS = 13000,
		PH_LENS_TRIPLINE_NRM_ERROR_VAL,

 //--------------------------------
 // Within this block, ID numbers must be identical across all plugins that support Lenses
	PH_LENS_DISTORT_MODEL = 15000,
		PH_LENS_MODEL_NONE = 0,
		PH_LENS_MODEL_ROT180 = 1,
		PH_LENS_MODEL_QUAD_CUBIC = 2,
		PH_LENS_MODEL_3DE_RADIAL_STANDARD_DEG4 = 3, // PHLENSMODE_11
		PH_LENS_MODEL_3DE_CLASSIC = 4,
		PH_LENS_MODEL_3DE_ANAMORPHIC_DEG4_ROT_SQZ = 5,
		PH_LENS_MODEL_3DE_ANAMORPHIC_DEG6 = 6,
		PH_LENS_MODEL_3DE_RADIAL_DEG8 = 7,

		PH_LENS_MODEL_3DE_RADIAL_STANDARD_DEG4_DECENTRED = 103,
		PH_LENS_MODEL_3DE_CLASSIC_DECENTRED = 104,
		PH_LENS_MODEL_3DE_ANAMORPHIC_DEG4_ROT_SQZ_DECENTRED = 105,
		PH_LENS_MODEL_3DE_ANAMORPHIC_DEG6_DECENTRED = 106,
		PH_LENS_MODEL_3DE_RADIAL_DEG8_DECENTRED = 107,

	PH_LENS_DISTORT_SOLVE_MODE = 15010,
		PH_LENS_DISTORT_SOLVE_MODE_MANUAL = 0,
		PH_LENS_DISTORT_SOLVE_MODE_AUTOMATIC = 1,

	PH_LENS_A0_PARAMS_GROUP_LEGACY = 15030,

	PH_LENS_M0_PARAMS_GROUP = 15050,
	PH_LENS_M1_PARAMS_GROUP,
	PH_LENS_M2_PARAMS_GROUP,
	PH_LENS_M3_PARAMS_GROUP, // PHLENSMODE_12
	PH_LENS_M4_PARAMS_GROUP,
	PH_LENS_M5_PARAMS_GROUP,
	PH_LENS_M6_PARAMS_GROUP,
	PH_LENS_M7_PARAMS_GROUP,

	// Model 0 params:
	// None.

	// Model 1 params:
	PH_LENS_M1_PARAM = 15100,

	// Model 2 params:
	PH_LENS_M2_QUADRATIC_DISTORTION = 15200,
	PH_LENS_M2_CUBIC_DISTORTION,
	PH_LENS_M2_PRINCIPAL_POINT_OFFSET_X,
	PH_LENS_M2_PRINCIPAL_POINT_OFFSET_Y,

	// Model 3 params: (Radial, Standard, Degree 4)
	PH_LENS_M3_C2 = 15300, // PHLENSMODE_13
	PH_LENS_M3_C4,
	PH_LENS_M3_U1, // Was T1
	PH_LENS_M3_V1, // Was T2
	PH_LENS_M3_T3_DEAD,
	PH_LENS_M3_U3,
	PH_LENS_M3_V3,
	PH_LENS_M3_PHI_CYL_DIR,
	PH_LENS_M3_B_CYL_BEND,

	PH_LENS_A3_OFFX = 15325,
	PH_LENS_A3_OFFY,


	// Model 4 params: (Classic LD Model)
	PH_LENS_M4_C2 = 15400,
	PH_LENS_M4_C4,
	PH_LENS_M4_XCRV,
	PH_LENS_M4_YCRV,
	PH_LENS_M4_ASQZ,

	PH_LENS_A4_OFFX = 15425,
	PH_LENS_A4_OFFY,


	// Model 5 params: (Anamorphic, Standard, Degree 4)
	PH_LENS_M5_Cx02 = 15450,
	PH_LENS_M5_Cy02,
	PH_LENS_M5_Cx22,
	PH_LENS_M5_Cy22,
	PH_LENS_M5_Cx04,
	PH_LENS_M5_Cy04,
	PH_LENS_M5_Cx24,
	PH_LENS_M5_Cy24,
	PH_LENS_M5_Cx44,
	PH_LENS_M5_Cy44,
	PH_LENS_M5_ROT,
	PH_LENS_M5_XSQZ,
	PH_LENS_M5_YSQZ,

	PH_LENS_A5_OFFX = 15475,
	PH_LENS_A5_OFFY,


	// Model 6 params: (Anamorphic, Degree 6)
	PH_LENS_M6_Cx02 = 15500,
	PH_LENS_M6_Cy02,
	PH_LENS_M6_Cx22,
	PH_LENS_M6_Cy22,
	PH_LENS_M6_Cx04,
	PH_LENS_M6_Cy04,
	PH_LENS_M6_Cx24,
	PH_LENS_M6_Cy24,
	PH_LENS_M6_Cx44,
	PH_LENS_M6_Cy44,
	PH_LENS_M6_Cx06,
	PH_LENS_M6_Cy06,
	PH_LENS_M6_Cx26,
	PH_LENS_M6_Cy26,
	PH_LENS_M6_Cx46,
	PH_LENS_M6_Cy46,
	PH_LENS_M6_Cx66,
	PH_LENS_M6_Cy66,

	PH_LENS_A6_OFFX = 15525,
	PH_LENS_A6_OFFY,


	// Model 7 params: (Radial Fisheye, Degree 8)
	PH_LENS_M7_C2 = 15550, // PHLENSMODE_13
	PH_LENS_M7_C4,
	PH_LENS_M7_C6,
	PH_LENS_M7_C8,

	PH_LENS_A7_OFFX = 15575,
	PH_LENS_A7_OFFY,


	// Adapter 0 params:
	PH_LENS_A0_OFFX_LEGACY = 15800,
	PH_LENS_A0_OFFY_LEGACY,

	//--------------------------------


	PH_LENS_DISTORT_AUTO_SOLVE,


	CM_IMAGE_VIEW_SCALE = 20000,
	CM_IMAGE_VIEW_OFFSET_X,
	CM_IMAGE_VIEW_OFFSET_Y,

	CM_IMAGE_VIEW_FULL,

	CM_IMAGE_MATCH_VIEW_WIDTH,
	CM_IMAGE_MATCH_VIEW_HEIGHT,

	CM_RDATA_RENDER_FILM_ASPECT,
//	CREATE_CAMERA_MAPPING_TEXTURE_TAG,
//	CREATE_BACKGROUND_OBJECT,

//	CM_IMAGE_SHOW_IMAGE_KILLME = 30000,

//	CM_LOUPE_MAGNIFICATION = 30001,
//	CM_LOUPE_SIZE_PIX,
//	CM_LOUPE_USE_OFFSET,

	LD_LENS_PROFILE_NAME = 35000,
	LD_LENS_LOAD_PROFILE,
	LD_LENS_SAVE_PROFILE,

	CM_GROUP_IMAGE = 40000, // Used in res for group label
	CM_GROUP_CALIBRATE, // Used in res for group label
	CM_GROUP_SETTINGS, // Used in res for group label
	CM_GROUP_LENS_DISTORTION,
	PH_GROUP_LENS_DISTORT_SOLVE_MODE_MANUAL,
	PH_GROUP_LENS_DISTORT_SOLVE_MODE_AUTOMATIC,
	//	CM_GROUP_LINKS,

//	LINKED_ELEMENT_LIST = 40050,

	CM_IMAGE_BRIGHTNESS = 40100,
//	CM_CALC_PP_WHEN_3VPS,
	CM_IMAGE_ROTATION,	// Note that although this appears as degrees in GUI, the value itself is radians.
};

#endif // TOOLLENSDISTORTION_H__

